function getFullPageHtml(output, color) {
    return '<div style="cursor:default;text-align: center;padding-bottom: 5px;padding-top: 4px;font-size: 12px;background-color: ' + color + ' ;color: white;">' + output + '</div>';
}

function isJson(str) {
    try {
        JSON.parse(str);
    } catch (e) {
        return false;
    }
    return true;
}

function checkUrl(url) {
    var id = url.match("tt\\d{7}");
    if (id !== null) {
        //call ajax request when its loaded

        var req = new XMLHttpRequest();
        req.open("GET", "http://wernersbacher.de/pro/imdbplugin/req2.php?type=get&id=" + id[0], true);
        req.onreadystatechange = function () {
            if (req.readyState === 4) {

                //Sarting DOM Manipulation
                var output = "", color = "";
                var call = req.responseText;            // CSS einfügen
                if (!call.length > 0) {
                    console.log("Can't connect to server");
                    output = "Can't connect to server!";
                }

                var obj = JSON.parse(call);

                if (obj["crawl_status"] === "ok") {
                    color = "rgb(0, 98, 31)";
                    output = "<a class='nlink' href='http://www.netflix.com/WiPlayer?movieid=" + obj["link"] + "' target='_blank'>Watch Now On Netflix</a>";
                }

                else if (obj["user_status"] === "ok" && obj["crawl_status"] === "bad") {

                    output = "(Not Crawled) Online Votes: ";

                    var votes = JSON.parse(call);
                    var percent = Math.round(100 * (parseInt(obj["yes"]) / (parseInt(obj["yes"]) + parseInt(obj["no"]))));
                    console.log(votes);
                    if (percent > 60)
                        color = "rgb(0, 98, 31)";
                    else
                        color = "rgb(100, 0, 0)";
                    output += percent;

                    output += "% say it's there. <span class='votebox'><b>Is it online?</b> <a class='yes' href='#'>Yes</a> | <a class='no' href='#'>No</a></span>";



                } else if (obj["crawl_status"] === "bad" && obj["user_status"] === "bad") {
                    output = "(Not Crawled) (No Votes) Is it on Netflix? <span class='votebox'><a class='nlink' class='yes' href='#'>Yes</a> | <a class='nlink' class='no' href='#'>No</a></span>";
                    color = "rgb(158, 158, 158)";

                }
                
                

                //Output text and clicks
                $("#maindetails_center_top").find(".watchbar2").append(getFullPageHtml(output, color));
                $("#maindetails_center_top").find(".yes, .no").click(function () {
                    //http://wernersbacher.de/pro/imdbplugin/req.php?type=vote&id=tt0111161&vote=no

                    var vote = $(this).attr("class");

                    var req = new XMLHttpRequest();
                    req.open("GET", "http://wernersbacher.de/pro/imdbplugin/req.php?type=vote&id=" + id[0] + "&vote=" + vote, true);
                    req.onreadystatechange = function () {
                        if (req.readyState === 4) {
                            if (req.responseText === "updated") {
                                $(".votebox").html("Thanks for voting!");
                            }
                        }
                    };
                    req.send();


                    //$(".votebox").html("Thanks for voting!");
                });



            }
        };
        req.send();


        //console.log(id[0]);
    }
}

console.log("Injected!");
checkUrl(window.location.href);